#pragma once
#include "../sdkIncludes.h"

typedef HMODULE JMHandle;
typedef long JMResult;

/**
*@brief defined of the result for HMResult
*/
#define JMSucceed ((JMResult)1)
#define JMFailed ((JMResult)0)

namespace JabberMeeting {
#ifdef WIN32
#ifdef JABBERMEETINGSERVICE_EXPORTS
#define JABBERMEETING_API __declspec(dllexport)
#else
#define JABBERMEETING_API __declspec(dllimport)
#endif
#endif

	extern "C"
	{
		JABBERMEETING_API JMResult jmevent_callback_set(const char *pEventName, void *pfFuncCallBack);
		JABBERMEETING_API JMResult jmsdk_function_get(const char *pFunctionName, void **pfRemotFunc);
	};

}


/***
*	IJMIMCallbackImpl
***/
#define JMSDK_IJMIMCallback_OnRecv_DSInvitation "JMSDK_IJMIMCallback_OnRecv_DSInvitation"

#define JMSDK_IJMIMCallback_OnRecv_DSDecline "JMSDK_IJMIMCallback_OnRecv_DSDecline"

#define JMSDK_IJMIMCallback_OnRecv_DSCancelled "JMSDK_IJMIMCallback_OnRecv_DSCancelled"

#define JMSDK_IJMIMCallback_OnRecv_MeetingInvitation "JMSDK_IJMIMCallback_OnRecv_MeetingInvitation"

#define JMSDK_IJMIMCallback_OnRecv_MeetingDecline "JMSDK_IJMIMCallback_OnRecv_MeetingDecline"

#define JMSDK_IJMIMCallback_OnRecv_MeetingCancelled "JMSDK_IJMIMCallback_OnRecv_MeetingCancelled"

#define JMSDK_IJMIMCallback_OnRecv_IMAlert "JMSDK_IJMIMCallback_OnRecv_IMAlert"

typedef JMResult (*pf_jmsdk_IJMIMCallback_OnRecv_DSInvitation)(wstring& strAccountName, wstring& strSessionName, wstring& strCmdMsg);

typedef JMResult (*pf_jmsdk_IJMIMCallback_OnRecv_DSDecline)(wstring& strAccountName, wstring& strSessionName, wstring& strCmdMsg);

typedef JMResult (*pf_jmsdk_IJMIMCallback_OnRecv_DSCancelled)(wstring& strAccountName, wstring& strSessionName, wstring& strCmdMsg);

typedef JMResult (*pf_jmsdk_IJMIMCallback_OnRecv_MeetingInvitation)(wstring& strAccountName, wstring& strSessionName, wstring& strCmdMsg);

typedef JMResult (*pf_jmsdk_IJMIMCallback_OnRecv_MeetingDecline)(wstring& strAccountName, wstring& strSessionName, wstring& strCmdMsg);

typedef JMResult (*pf_jmsdk_IJMIMCallback_OnRecv_MeetingCancelled)(wstring& strAccountName, wstring& strSessionName, wstring& strCmdMsg);

typedef JMResult (*pf_jmsdk_IJMIMCallback_OnRecv_IMAlert)(wstring& strAccountName, wstring& strSessionName, wstring& strCmdMsg);


/***
*	IJMCommonEventCallbackImpl
***/
#define JMSDK_IJMCommonEventCallback_OnSignOn "JMSDK_IJMCommonEventCallback_OnSignOn"

#define JMSDK_IJMCommonEventCallback_OnSignOff "JMSDK_IJMCommonEventCallback_OnSignOff"

#define JMSDK_IJMCommonEventCallback_OnPreseceChange "JMSDK_IJMCommonEventCallback_OnPreseceChange"

#define JMSDK_IJMCommonEventCallback_OnUserSignOff "JMSDK_IJMCommonEventCallback_OnUserSignOff"

#define JMSDK_IJMCommonEventCallback_OnDSParamReady "JMSDK_IJMCommonEventCallback_OnDSParamReady"

typedef JMResult (*pf_jmsdk_IJMCommonEventCallback_OnSignOn)();

typedef JMResult (*pf_jmsdk_IJMCommonEventCallback_OnSignOff)();

typedef JMResult (*pf_jmsdk_IJMCommonEventCallback_OnPreseceChange)();

typedef JMResult (*pf_jmsdk_IJMCommonEventCallback_OnUserSignOff)(const wstring& strBuddyName);

typedef JMResult (*pf_jmsdk_IJMCommonEventCallback_OnDSParamReady)(const wstring& strDSURL, const wstring& strDSToken);


/***
*	JMMeetingMgrImpl
***/
#define JMSDK_JMMeetingMgr_Initialize "JMSDK_JMMeetingMgr_Initialize"

#define JMSDK_JMMeetingMgr_ReleaseResources "JMSDK_JMMeetingMgr_ReleaseResources"

#define JMSDK_JMMeetingMgr_NetworkChanged "JMSDK_JMMeetingMgr_NetworkChanged"

#define JMSDK_JMMeetingMgr_GetOnlineSwitch "JMSDK_JMMeetingMgr_GetOnlineSwitch"

#define JMSDK_JMMeetingMgr_GetOfflineSwitch "JMSDK_JMMeetingMgr_GetOfflineSwitch"

#define JMSDK_JMMeetingMgr_ListEvents "JMSDK_JMMeetingMgr_ListEvents"

#define JMSDK_JMMeetingMgr_RefreshCalendar "JMSDK_JMMeetingMgr_RefreshCalendar"

#define JMSDK_JMMeetingMgr_TodayChanged "JMSDK_JMMeetingMgr_TodayChanged"

#define JMSDK_JMMeetingMgr_GetWbxMeetingDetail "JMSDK_JMMeetingMgr_GetWbxMeetingDetail"

#define JMSDK_JMMeetingMgr_GetCMRInfo "JMSDK_JMMeetingMgr_GetCMRInfo"

#define JMSDK_JMMeetingMgr_ViewEvent "JMSDK_JMMeetingMgr_ViewEvent"

#define JMSDK_JMMeetingMgr_GetCurrentMailType "JMSDK_JMMeetingMgr_GetCurrentMailType"

#define JMSDK_JMMeetingMgr_LaunchWebexMeeting "JMSDK_JMMeetingMgr_LaunchWebexMeeting"

#define JMSDK_JMMeetingMgr_SendMail "JMSDK_JMMeetingMgr_SendMail"

typedef JMResult (*pf_jmsdk_JMMeetingMgr_Initialize)(ConOIServieType const &conType, HRESULT &ret);

typedef JMResult (*pf_jmsdk_JMMeetingMgr_ReleaseResources)(HRESULT &ret);

typedef JMResult (*pf_jmsdk_JMMeetingMgr_NetworkChanged)(BOOL bConnected, HRESULT &ret);

typedef JMResult (*pf_jmsdk_JMMeetingMgr_GetOnlineSwitch)(OUT BOOL * pVal, HRESULT &ret);

typedef JMResult (*pf_jmsdk_JMMeetingMgr_GetOfflineSwitch)(OUT BOOL * pVal, HRESULT &ret);

typedef JMResult (*pf_jmsdk_JMMeetingMgr_ListEvents)(IN const SYSTEMTIME& stSelectedDay, HRESULT &ret);

typedef JMResult (*pf_jmsdk_JMMeetingMgr_RefreshCalendar)(HRESULT &ret);

typedef JMResult (*pf_jmsdk_JMMeetingMgr_TodayChanged)(IN BOOL bForceRefresh, HRESULT &ret);

typedef JMResult (*pf_jmsdk_JMMeetingMgr_GetWbxMeetingDetail)(IN wstring const& strEventID, HRESULT &ret);

typedef JMResult (*pf_jmsdk_JMMeetingMgr_GetCMRInfo)(IN wstring const& strMeetingKeyList, HRESULT &ret);

typedef JMResult (*pf_jmsdk_JMMeetingMgr_ViewEvent)(IN wstring const& strEventID, HRESULT &ret);

typedef JMResult (*pf_jmsdk_JMMeetingMgr_GetCurrentMailType)(OUT ConOIServieType& conType, HRESULT &ret);

typedef JMResult (*pf_jmsdk_JMMeetingMgr_LaunchWebexMeeting)(IN wstring const& strEventID, HRESULT &ret);

typedef JMResult (*pf_jmsdk_JMMeetingMgr_SendMail)(IN const wstring& strSubject, IN const wstring& strTos, IN const wstring& strBody, IN const wstring& strMeetingKey, HRESULT &ret);


/***
*	IWbxMeetingAccountMgrImpl
***/
#define JMSDK_IWbxMeetingAccountMgr_RegisterObserver "JMSDK_IWbxMeetingAccountMgr_RegisterObserver"

#define JMSDK_IWbxMeetingAccountMgr_UnregisterObserver "JMSDK_IWbxMeetingAccountMgr_UnregisterObserver"

#define JMSDK_IWbxMeetingAccountMgr_IsActiveAccountExist "JMSDK_IWbxMeetingAccountMgr_IsActiveAccountExist"

#define JMSDK_IWbxMeetingAccountMgr_VerifyAccount "JMSDK_IWbxMeetingAccountMgr_VerifyAccount"

#define JMSDK_IWbxMeetingAccountMgr_SetAccountEmpty "JMSDK_IWbxMeetingAccountMgr_SetAccountEmpty"

#define JMSDK_IWbxMeetingAccountMgr_SetActiveAccount "JMSDK_IWbxMeetingAccountMgr_SetActiveAccount"

#define JMSDK_IWbxMeetingAccountMgr_NoticeInvalidCertInMeetingSite "JMSDK_IWbxMeetingAccountMgr_NoticeInvalidCertInMeetingSite"

#define JMSDK_IWbxMeetingAccountMgr_GetMeetingAccount "JMSDK_IWbxMeetingAccountMgr_GetMeetingAccount"

#define JMSDK_IWbxMeetingAccountMgr_RefreshSessionTicket "JMSDK_IWbxMeetingAccountMgr_RefreshSessionTicket"

#define JMSDK_IWbxMeetingAccountMgr_CheckSSOSiteList "JMSDK_IWbxMeetingAccountMgr_CheckSSOSiteList"

#define JMSDK_IWbxMeetingAccountMgr_CheckSiteSSOFlag "JMSDK_IWbxMeetingAccountMgr_CheckSiteSSOFlag"

#define JMSDK_IWbxMeetingAccountMgr_GetSiteSSOFlag "JMSDK_IWbxMeetingAccountMgr_GetSiteSSOFlag"

typedef JMResult (*pf_jmsdk_IWbxMeetingAccountMgr_RegisterObserver)(IWbxMeetingAccountObserve *pOB);

typedef JMResult (*pf_jmsdk_IWbxMeetingAccountMgr_UnregisterObserver)(IWbxMeetingAccountObserve *pOB);

typedef JMResult (*pf_jmsdk_IWbxMeetingAccountMgr_IsActiveAccountExist)(bool &ret);

typedef JMResult (*pf_jmsdk_IWbxMeetingAccountMgr_VerifyAccount)(const wstring& strSiteUrl, const wstring& strUserName, const wstring& strCred, bool bSSO);

typedef JMResult (*pf_jmsdk_IWbxMeetingAccountMgr_SetAccountEmpty)();

typedef JMResult (*pf_jmsdk_IWbxMeetingAccountMgr_SetActiveAccount)(TWBXMeetingAccountInfo& account);

typedef JMResult (*pf_jmsdk_IWbxMeetingAccountMgr_NoticeInvalidCertInMeetingSite)(JMErrorCodeDef::EJMMeetingAccountErrorCode eErrCode);

typedef JMResult (*pf_jmsdk_IWbxMeetingAccountMgr_GetMeetingAccount)(TWBXMeetingAccountInfo& account);

typedef JMResult (*pf_jmsdk_IWbxMeetingAccountMgr_RefreshSessionTicket)(const wstring& strSessionTicket);

typedef JMResult (*pf_jmsdk_IWbxMeetingAccountMgr_CheckSSOSiteList)(const wstring& strSiteList);

typedef JMResult (*pf_jmsdk_IWbxMeetingAccountMgr_CheckSiteSSOFlag)(const wstring& strSiteUrl);

typedef JMResult (*pf_jmsdk_IWbxMeetingAccountMgr_GetSiteSSOFlag)(const wstring& strSiteUrl, E_WBX_SITE_SSO_FLAG &ret);


/***
*	IMeetingAccountInfoCallbackImpl
***/
#define JMSDK_IMeetingAccountInfoCallback_OnWapiGetAllAccount "JMSDK_IMeetingAccountInfoCallback_OnWapiGetAllAccount"

#define JMSDK_IMeetingAccountInfoCallback_OnWapiGetDefaultAccount "JMSDK_IMeetingAccountInfoCallback_OnWapiGetDefaultAccount"

#define JMSDK_IMeetingAccountInfoCallback_OnWapiDelAccount "JMSDK_IMeetingAccountInfoCallback_OnWapiDelAccount"

#define JMSDK_IMeetingAccountInfoCallback_OnWapiSetAccount "JMSDK_IMeetingAccountInfoCallback_OnWapiSetAccount"

typedef JMResult (*pf_jmsdk_IMeetingAccountInfoCallback_OnWapiGetAllAccount)(BOOL bSuccess, vector<TWBXMeetingAccountInfo> &accounts);

typedef JMResult (*pf_jmsdk_IMeetingAccountInfoCallback_OnWapiGetDefaultAccount)(BOOL bSuccess, TWBXMeetingAccountInfo &account, wstring& strSKCreateTime, wstring& strSKTime2Live, wstring strReason, int nExceptionID);

typedef JMResult (*pf_jmsdk_IMeetingAccountInfoCallback_OnWapiDelAccount)(BOOL bSuccess, INT nExceptionID, wstring& strReason);

typedef JMResult (*pf_jmsdk_IMeetingAccountInfoCallback_OnWapiSetAccount)(BOOL bSuccess, TWBXMeetingAccountInfo &account, wstring& strSKCreateTime, wstring& strSKTime2Live, wstring strReason, int nExceptionID);


/***
*	IInstantMeetingMgrImpl
***/
#define JMSDK_IInstantMeetingMgr_RegisterEvent "JMSDK_IInstantMeetingMgr_RegisterEvent"

#define JMSDK_IInstantMeetingMgr_UnregisterEvent "JMSDK_IInstantMeetingMgr_UnregisterEvent"

#define JMSDK_IInstantMeetingMgr_OpenOneClickSetting "JMSDK_IInstantMeetingMgr_OpenOneClickSetting"

#define JMSDK_IInstantMeetingMgr_GetLastError "JMSDK_IInstantMeetingMgr_GetLastError"

#define JMSDK_IInstantMeetingMgr_IsInMeeting "JMSDK_IInstantMeetingMgr_IsInMeeting"

#define JMSDK_IInstantMeetingMgr_CanStartMeeting "JMSDK_IInstantMeetingMgr_CanStartMeeting"

#define JMSDK_IInstantMeetingMgr_CanJoinMeeting "JMSDK_IInstantMeetingMgr_CanJoinMeeting"

#define JMSDK_IInstantMeetingMgr_StartInstantMeeting "JMSDK_IInstantMeetingMgr_StartInstantMeeting"

#define JMSDK_IInstantMeetingMgr_Accept "JMSDK_IInstantMeetingMgr_Accept"

#define JMSDK_IInstantMeetingMgr_Decline "JMSDK_IInstantMeetingMgr_Decline"

#define JMSDK_IInstantMeetingMgr_Reinvite "JMSDK_IInstantMeetingMgr_Reinvite"

#define JMSDK_IInstantMeetingMgr_OpenMeetingDetailPage "JMSDK_IInstantMeetingMgr_OpenMeetingDetailPage"

#define JMSDK_IInstantMeetingMgr_StartJoinMeetingByUrl "JMSDK_IInstantMeetingMgr_StartJoinMeetingByUrl"

#define JMSDK_IInstantMeetingMgr_StartScheduledMeeting "JMSDK_IInstantMeetingMgr_StartScheduledMeeting"

#define JMSDK_IInstantMeetingMgr_LaunchMeetingByJoinURL "JMSDK_IInstantMeetingMgr_LaunchMeetingByJoinURL"

#define JMSDK_IInstantMeetingMgr_JoinMeetingByMK "JMSDK_IInstantMeetingMgr_JoinMeetingByMK"

#define JMSDK_IInstantMeetingMgr_IsMeetingInProgress "JMSDK_IInstantMeetingMgr_IsMeetingInProgress"

#define JMSDK_IInstantMeetingMgr_GetJoinURL "JMSDK_IInstantMeetingMgr_GetJoinURL"

#define JMSDK_IInstantMeetingMgr_GetInstantMeetingInfoByMK "JMSDK_IInstantMeetingMgr_GetInstantMeetingInfoByMK"

#define JMSDK_IInstantMeetingMgr_StartCMRMeeting "JMSDK_IInstantMeetingMgr_StartCMRMeeting"

#define JMSDK_IInstantMeetingMgr_JoinCMRMeeting "JMSDK_IInstantMeetingMgr_JoinCMRMeeting"

typedef JMResult (*pf_jmsdk_IInstantMeetingMgr_RegisterEvent)(IInstantMeetingEvent * pEvent);

typedef JMResult (*pf_jmsdk_IInstantMeetingMgr_UnregisterEvent)(IInstantMeetingEvent * pEvent);

typedef JMResult (*pf_jmsdk_IInstantMeetingMgr_OpenOneClickSetting)();

typedef JMResult (*pf_jmsdk_IInstantMeetingMgr_GetLastError)(wstring& strErrMsg, int &ret);

typedef JMResult (*pf_jmsdk_IInstantMeetingMgr_IsInMeeting)(BOOL &ret);

typedef JMResult (*pf_jmsdk_IInstantMeetingMgr_CanStartMeeting)(BOOL &ret);

typedef JMResult (*pf_jmsdk_IInstantMeetingMgr_CanJoinMeeting)(const wstring& strSessionKey, BOOL &ret);

typedef JMResult (*pf_jmsdk_IInstantMeetingMgr_StartInstantMeeting)(wstring const& strMeetingName, vector<InviteeInfo> const& vecUserList, wstring const&  strDefSessionID, BOOL &ret);

typedef JMResult (*pf_jmsdk_IInstantMeetingMgr_Accept)(const wstring& strSessionName, BOOL &ret);

typedef JMResult (*pf_jmsdk_IInstantMeetingMgr_Decline)(const wstring& strSessionName, BOOL &ret);

typedef JMResult (*pf_jmsdk_IInstantMeetingMgr_Reinvite)(const wstring& strSessionName, BOOL &ret);

typedef JMResult (*pf_jmsdk_IInstantMeetingMgr_OpenMeetingDetailPage)(const TCHAR* pszJoinUrl, BOOL &ret);

typedef JMResult (*pf_jmsdk_IInstantMeetingMgr_StartJoinMeetingByUrl)(const TCHAR* pszJoinUrl, BOOL &ret);

typedef JMResult (*pf_jmsdk_IInstantMeetingMgr_StartScheduledMeeting)(wstring const& strMeetingKey, BOOL &ret);

typedef JMResult (*pf_jmsdk_IInstantMeetingMgr_LaunchMeetingByJoinURL)(wstring const& strJoinURL, BOOL bHost, wstring const& strEventID, BOOL &ret);

typedef JMResult (*pf_jmsdk_IInstantMeetingMgr_JoinMeetingByMK)(wstring const& strMeetingKey, wstring const& strMeetingPass, BOOL &ret);

typedef JMResult (*pf_jmsdk_IInstantMeetingMgr_IsMeetingInProgress)(IN const wstring& strMeetingKey, BOOL &ret);

typedef JMResult (*pf_jmsdk_IInstantMeetingMgr_GetJoinURL)(const TCHAR* pszSite, const TCHAR* pszEventID, const TCHAR* pszMeetingKey, const TCHAR* pszMeetingPwd, bool bSetMK, const TCHAR* pszEmail, const TCHAR* pszUserName, TCHAR* pszURL, unsigned long* pulURLLen, int eSenario, BOOL &ret);

typedef JMResult (*pf_jmsdk_IInstantMeetingMgr_GetInstantMeetingInfoByMK)(const wstring& strMeetingKey, DWORD& dwSiteType, wstring& strInviteByEmail, wstring& strQSInviteURL, wstring& strInviteCode, wstring& strOfflineBuddies, BOOL& bFromClient, BOOL& bHost);

typedef JMResult (*pf_jmsdk_IInstantMeetingMgr_StartCMRMeeting)(BOOL isLaunchMeeting, BOOL &ret);

typedef JMResult (*pf_jmsdk_IInstantMeetingMgr_JoinCMRMeeting)(wstring const& strSiteURL, wstring const& strMeetingKey, wstring const& strMTGTK, BOOL &ret);


/***
*	IDSMgrImpl
***/
#define JMSDK_IDSMgr_CancelStartSharing "JMSDK_IDSMgr_CancelStartSharing"

#define JMSDK_IDSMgr_CanStartSharing "JMSDK_IDSMgr_CanStartSharing"

#define JMSDK_IDSMgr_IsInsharing "JMSDK_IDSMgr_IsInsharing"

#define JMSDK_IDSMgr_Start "JMSDK_IDSMgr_Start"

#define JMSDK_IDSMgr_Join "JMSDK_IDSMgr_Join"

#define JMSDK_IDSMgr_Decline "JMSDK_IDSMgr_Decline"

#define JMSDK_IDSMgr_StopCurSession "JMSDK_IDSMgr_StopCurSession"

#define JMSDK_IDSMgr_ReInviteCurSession "JMSDK_IDSMgr_ReInviteCurSession"

#define JMSDK_IDSMgr_ReSharing "JMSDK_IDSMgr_ReSharing"

#define JMSDK_IDSMgr_ChangePresenter "JMSDK_IDSMgr_ChangePresenter"

#define JMSDK_IDSMgr_IsPresenter "JMSDK_IDSMgr_IsPresenter"

#define JMSDK_IDSMgr_CanJoinSharing "JMSDK_IDSMgr_CanJoinSharing"

typedef JMResult (*pf_jmsdk_IDSMgr_CancelStartSharing)(BOOL &ret);

typedef JMResult (*pf_jmsdk_IDSMgr_CanStartSharing)(const wstring& strSessionName, BOOL &ret);

typedef JMResult (*pf_jmsdk_IDSMgr_IsInsharing)(BOOL &ret);

typedef JMResult (*pf_jmsdk_IDSMgr_Start)(const wstring& strSessionName, BOOL &ret);

typedef JMResult (*pf_jmsdk_IDSMgr_Join)(const wstring& strSessionName, BOOL &ret);

typedef JMResult (*pf_jmsdk_IDSMgr_Decline)(const wstring& strSessionName, BOOL &ret);

typedef JMResult (*pf_jmsdk_IDSMgr_StopCurSession)(BOOL &ret);

typedef JMResult (*pf_jmsdk_IDSMgr_ReInviteCurSession)(BOOL &ret);

typedef JMResult (*pf_jmsdk_IDSMgr_ReSharing)(BOOL &ret);

typedef JMResult (*pf_jmsdk_IDSMgr_ChangePresenter)(BOOL &ret);

typedef JMResult (*pf_jmsdk_IDSMgr_IsPresenter)(BOOL &ret);

typedef JMResult (*pf_jmsdk_IDSMgr_CanJoinSharing)(const wstring& strSessionName, INT& eType, BOOL &ret);


/***
*	IJMIMDelegeteWrapper
***/
#define JMSDK_IJMIMDelegete_SendCmd_DSInvitation "JMSDK_IJMIMDelegete_SendCmd_DSInvitation"

#define JMSDK_IJMIMDelegete_SendCmd_DSDecline "JMSDK_IJMIMDelegete_SendCmd_DSDecline"

#define JMSDK_IJMIMDelegete_SendCmd_DSCancelled "JMSDK_IJMIMDelegete_SendCmd_DSCancelled"

#define JMSDK_IJMIMDelegete_SendCmd_MeetingInvitation "JMSDK_IJMIMDelegete_SendCmd_MeetingInvitation"

#define JMSDK_IJMIMDelegete_SendCmd_MeetingDecline "JMSDK_IJMIMDelegete_SendCmd_MeetingDecline"

#define JMSDK_IJMIMDelegete_SendCmd_MeetingCancelled "JMSDK_IJMIMDelegete_SendCmd_MeetingCancelled"

#define JMSDK_IJMIMDelegete_SendCmd_IMAlert "JMSDK_IJMIMDelegete_SendCmd_IMAlert"

typedef BOOL (*pf_jmsdk_IJMIMDelegete_SendCmd_DSInvitation)(const wstring& strBuddyName, const wstring& strCmd, const wstring& strHtmlMessage, const wstring& strPlainMessage);

typedef BOOL (*pf_jmsdk_IJMIMDelegete_SendCmd_DSDecline)(wstring& strSessionName, wstring& strCmdMsg);

typedef BOOL (*pf_jmsdk_IJMIMDelegete_SendCmd_DSCancelled)(wstring& strSessionName, wstring& strCmdMsg);

typedef BOOL (*pf_jmsdk_IJMIMDelegete_SendCmd_MeetingInvitation)(const wstring& strBuddyName, const wstring& strCmd, const wstring& strHtmlMessage, const wstring& strPlainMessage);

typedef BOOL (*pf_jmsdk_IJMIMDelegete_SendCmd_MeetingDecline)(wstring& strSessionName, wstring& strCmdMsg);

typedef BOOL (*pf_jmsdk_IJMIMDelegete_SendCmd_MeetingCancelled)(wstring& strSessionName, wstring& strCmdMsg);

typedef BOOL (*pf_jmsdk_IJMIMDelegete_SendCmd_IMAlert)(const wstring& strBuddyName, const wstring& strCmd, const wstring& strHtmlMessage, const wstring& strPlainMessage);


/***
*	ICommonDependenciesDelegateWrapper
***/
#define JMSDK_ICommonDependenciesDelegate_GetMyAccountName "JMSDK_ICommonDependenciesDelegate_GetMyAccountName"

#define JMSDK_ICommonDependenciesDelegate_GetMyAccountDisplayName "JMSDK_ICommonDependenciesDelegate_GetMyAccountDisplayName"

#define JMSDK_ICommonDependenciesDelegate_GetMyAccountEmail "JMSDK_ICommonDependenciesDelegate_GetMyAccountEmail"

#define JMSDK_ICommonDependenciesDelegate_GetBuddyDispName "JMSDK_ICommonDependenciesDelegate_GetBuddyDispName"

#define JMSDK_ICommonDependenciesDelegate_GetBuddyEmail "JMSDK_ICommonDependenciesDelegate_GetBuddyEmail"

#define JMSDK_ICommonDependenciesDelegate_GetBuddyURIWithEmailaddress "JMSDK_ICommonDependenciesDelegate_GetBuddyURIWithEmailaddress"

#define JMSDK_ICommonDependenciesDelegate_IsAccount "JMSDK_ICommonDependenciesDelegate_IsAccount"

#define JMSDK_ICommonDependenciesDelegate_IsSignedOn "JMSDK_ICommonDependenciesDelegate_IsSignedOn"

#define JMSDK_ICommonDependenciesDelegate_IsDSPolicyEnable "JMSDK_ICommonDependenciesDelegate_IsDSPolicyEnable"

#define JMSDK_ICommonDependenciesDelegate_AutoRespPolicy "JMSDK_ICommonDependenciesDelegate_AutoRespPolicy"

#define JMSDK_ICommonDependenciesDelegate_HasDSCapability "JMSDK_ICommonDependenciesDelegate_HasDSCapability"

#define JMSDK_ICommonDependenciesDelegate_HasIMCapability "JMSDK_ICommonDependenciesDelegate_HasIMCapability"

#define JMSDK_ICommonDependenciesDelegate_IsBuddyOnline "JMSDK_ICommonDependenciesDelegate_IsBuddyOnline"

#define JMSDK_ICommonDependenciesDelegate_IsCupMode "JMSDK_ICommonDependenciesDelegate_IsCupMode"

#define JMSDK_ICommonDependenciesDelegate_IsWbxMeetingEnabled "JMSDK_ICommonDependenciesDelegate_IsWbxMeetingEnabled"

#define JMSDK_ICommonDependenciesDelegate_GetDSURL "JMSDK_ICommonDependenciesDelegate_GetDSURL"

#define JMSDK_ICommonDependenciesDelegate_GetDSToken "JMSDK_ICommonDependenciesDelegate_GetDSToken"

#define JMSDK_ICommonDependenciesDelegate_GetDSParam "JMSDK_ICommonDependenciesDelegate_GetDSParam"

#define JMSDK_ICommonDependenciesDelegate_ProbeP2PDnd "JMSDK_ICommonDependenciesDelegate_ProbeP2PDnd"

#define JMSDK_ICommonDependenciesDelegate_AutoRespDnd "JMSDK_ICommonDependenciesDelegate_AutoRespDnd"

#define JMSDK_ICommonDependenciesDelegate_AddInMeetingStatus "JMSDK_ICommonDependenciesDelegate_AddInMeetingStatus"

#define JMSDK_ICommonDependenciesDelegate_RemoveInMeetingStatus "JMSDK_ICommonDependenciesDelegate_RemoveInMeetingStatus"

#define JMSDK_ICommonDependenciesDelegate_AddInWebExMeetingStatus "JMSDK_ICommonDependenciesDelegate_AddInWebExMeetingStatus"

#define JMSDK_ICommonDependenciesDelegate_RemoveInWebExMeetingStatus "JMSDK_ICommonDependenciesDelegate_RemoveInWebExMeetingStatus"

#define JMSDK_ICommonDependenciesDelegate_AddSharingInWebExMeetingStatus "JMSDK_ICommonDependenciesDelegate_AddSharingInWebExMeetingStatus"

#define JMSDK_ICommonDependenciesDelegate_RemoveSharingInWebExMeetingStatus "JMSDK_ICommonDependenciesDelegate_RemoveSharingInWebExMeetingStatus"

#define JMSDK_ICommonDependenciesDelegate_AddInDSStatus "JMSDK_ICommonDependenciesDelegate_AddInDSStatus"

#define JMSDK_ICommonDependenciesDelegate_RemoveInDSStatus "JMSDK_ICommonDependenciesDelegate_RemoveInDSStatus"

#define JMSDK_ICommonDependenciesDelegate_AddSharingInDSStatus "JMSDK_ICommonDependenciesDelegate_AddSharingInDSStatus"

#define JMSDK_ICommonDependenciesDelegate_RemoveSharingInDSStatus "JMSDK_ICommonDependenciesDelegate_RemoveSharingInDSStatus"

#define JMSDK_ICommonDependenciesDelegate_GetCalendarAutoRefreshTime "JMSDK_ICommonDependenciesDelegate_GetCalendarAutoRefreshTime"

typedef wstring (*pf_jmsdk_ICommonDependenciesDelegate_GetMyAccountName)();

typedef wstring (*pf_jmsdk_ICommonDependenciesDelegate_GetMyAccountDisplayName)();

typedef wstring (*pf_jmsdk_ICommonDependenciesDelegate_GetMyAccountEmail)();

typedef wstring (*pf_jmsdk_ICommonDependenciesDelegate_GetBuddyDispName)(const wstring& strURI);

typedef wstring (*pf_jmsdk_ICommonDependenciesDelegate_GetBuddyEmail)(const wstring &strBuddyName);

typedef wstring (*pf_jmsdk_ICommonDependenciesDelegate_GetBuddyURIWithEmailaddress)(const wstring& strEmailaddress);

typedef BOOL (*pf_jmsdk_ICommonDependenciesDelegate_IsAccount)(const wstring& strSessionName);

typedef BOOL (*pf_jmsdk_ICommonDependenciesDelegate_IsSignedOn)();

typedef BOOL (*pf_jmsdk_ICommonDependenciesDelegate_IsDSPolicyEnable)(const wstring& strSessionName, int& nPolicyResult);

typedef BOOL (*pf_jmsdk_ICommonDependenciesDelegate_AutoRespPolicy)(wstring const& strBuddyName, int nPolicyResult);

typedef BOOL (*pf_jmsdk_ICommonDependenciesDelegate_HasDSCapability)(const wstring& strSessionName);

typedef BOOL (*pf_jmsdk_ICommonDependenciesDelegate_HasIMCapability)(const wstring& strSessionName);

typedef BOOL (*pf_jmsdk_ICommonDependenciesDelegate_IsBuddyOnline)(const wstring& strSessionName);

typedef BOOL (*pf_jmsdk_ICommonDependenciesDelegate_IsCupMode)();

typedef BOOL (*pf_jmsdk_ICommonDependenciesDelegate_IsWbxMeetingEnabled)();

typedef wstring (*pf_jmsdk_ICommonDependenciesDelegate_GetDSURL)();

typedef wstring (*pf_jmsdk_ICommonDependenciesDelegate_GetDSToken)();

typedef wstring (*pf_jmsdk_ICommonDependenciesDelegate_GetDSParam)();

typedef BOOL (*pf_jmsdk_ICommonDependenciesDelegate_ProbeP2PDnd)(wstring const& strBuddyName);

typedef BOOL (*pf_jmsdk_ICommonDependenciesDelegate_AutoRespDnd)(wstring const& strBuddyName);

typedef void (*pf_jmsdk_ICommonDependenciesDelegate_AddInMeetingStatus)();

typedef void (*pf_jmsdk_ICommonDependenciesDelegate_RemoveInMeetingStatus)();

typedef void (*pf_jmsdk_ICommonDependenciesDelegate_AddInWebExMeetingStatus)();

typedef void (*pf_jmsdk_ICommonDependenciesDelegate_RemoveInWebExMeetingStatus)();

typedef void (*pf_jmsdk_ICommonDependenciesDelegate_AddSharingInWebExMeetingStatus)();

typedef void (*pf_jmsdk_ICommonDependenciesDelegate_RemoveSharingInWebExMeetingStatus)();

typedef void (*pf_jmsdk_ICommonDependenciesDelegate_AddInDSStatus)();

typedef void (*pf_jmsdk_ICommonDependenciesDelegate_RemoveInDSStatus)();

typedef void (*pf_jmsdk_ICommonDependenciesDelegate_AddSharingInDSStatus)();

typedef void (*pf_jmsdk_ICommonDependenciesDelegate_RemoveSharingInDSStatus)();

typedef unsigned int (*pf_jmsdk_ICommonDependenciesDelegate_GetCalendarAutoRefreshTime)();


/***
*	JMLoggerWrapper
***/
#define JMSDK_JMLogger_log "JMSDK_JMLogger_log"

typedef void (*pf_jmsdk_JMLogger_log)(int level, const char *sourceFile, int sourceLine, const char* function, const char* fmt, va_list args);


/***
*	JMMeetingMgrHandlerWrapper
***/
#define JMSDK_JMMeetingMgrHandler_OnListOneDayEvents "JMSDK_JMMeetingMgrHandler_OnListOneDayEvents"

#define JMSDK_JMMeetingMgrHandler_OnMeetingStart "JMSDK_JMMeetingMgrHandler_OnMeetingStart"

#define JMSDK_JMMeetingMgrHandler_OnMeetingEnd "JMSDK_JMMeetingMgrHandler_OnMeetingEnd"

#define JMSDK_JMMeetingMgrHandler_OnOvernight "JMSDK_JMMeetingMgrHandler_OnOvernight"

#define JMSDK_JMMeetingMgrHandler_OnGetWbxMeetingDetail "JMSDK_JMMeetingMgrHandler_OnGetWbxMeetingDetail"

#define JMSDK_JMMeetingMgrHandler_OnInitializeOIFailed "JMSDK_JMMeetingMgrHandler_OnInitializeOIFailed"

#define JMSDK_JMMeetingMgrHandler_OnInitializeResult "JMSDK_JMMeetingMgrHandler_OnInitializeResult"

#define JMSDK_JMMeetingMgrHandler_OnMeetingReminderHappened "JMSDK_JMMeetingMgrHandler_OnMeetingReminderHappened"

#define JMSDK_JMMeetingMgrHandler_OnMeetingReminderEnded "JMSDK_JMMeetingMgrHandler_OnMeetingReminderEnded"

#define JMSDK_JMMeetingMgrHandler_OnMeetingIMAlertHappened "JMSDK_JMMeetingMgrHandler_OnMeetingIMAlertHappened"

#define JMSDK_JMMeetingMgrHandler_OnGetCMRInfo "JMSDK_JMMeetingMgrHandler_OnGetCMRInfo"

typedef void (*pf_jmsdk_JMMeetingMgrHandler_OnListOneDayEvents)(wstring const& strEvents);

typedef void (*pf_jmsdk_JMMeetingMgrHandler_OnMeetingStart)(wstring const& strEventID, wstring const& strMeetingKey);

typedef void (*pf_jmsdk_JMMeetingMgrHandler_OnMeetingEnd)(wstring const& strEventID, wstring const& strMeetingKey);

typedef void (*pf_jmsdk_JMMeetingMgrHandler_OnOvernight)(MeetingMgrErrorCode eRet);

typedef void (*pf_jmsdk_JMMeetingMgrHandler_OnGetWbxMeetingDetail)(wstring const& strEventXML, wstring const& strMeetingDetail);

typedef void (*pf_jmsdk_JMMeetingMgrHandler_OnInitializeOIFailed)();

typedef void (*pf_jmsdk_JMMeetingMgrHandler_OnInitializeResult)(LONG const &lResult);

typedef void (*pf_jmsdk_JMMeetingMgrHandler_OnMeetingReminderHappened)(MeetingReminderItem const& objMeetingReminderItem);

typedef void (*pf_jmsdk_JMMeetingMgrHandler_OnMeetingReminderEnded)(wstring const & strEventID);

typedef void (*pf_jmsdk_JMMeetingMgrHandler_OnMeetingIMAlertHappened)(MeetingIMAlertItem const &obj);

typedef void (*pf_jmsdk_JMMeetingMgrHandler_OnGetCMRInfo)(const wstring& cmrInfo);


/***
*	IWbxMeetingAccountObserveWrapper
***/
#define JMSDK_IWbxMeetingAccountObserve_OnVerifyAccount "JMSDK_IWbxMeetingAccountObserve_OnVerifyAccount"

#define JMSDK_IWbxMeetingAccountObserve_OnNoticeActiveAccountChange "JMSDK_IWbxMeetingAccountObserve_OnNoticeActiveAccountChange"

#define JMSDK_IWbxMeetingAccountObserve_OnNoticeSessionTicketRefreshed "JMSDK_IWbxMeetingAccountObserve_OnNoticeSessionTicketRefreshed"

#define JMSDK_IWbxMeetingAccountObserve_OnNoticeInvalidCertInMeetingSite "JMSDK_IWbxMeetingAccountObserve_OnNoticeInvalidCertInMeetingSite"

#define JMSDK_IWbxMeetingAccountObserve_OnCheckSSOSiteListReady "JMSDK_IWbxMeetingAccountObserve_OnCheckSSOSiteListReady"

#define JMSDK_IWbxMeetingAccountObserve_OnCheckSiteSSOFlagReady "JMSDK_IWbxMeetingAccountObserve_OnCheckSiteSSOFlagReady"

typedef void (*pf_jmsdk_IWbxMeetingAccountObserve_OnVerifyAccount)(bool bSuccess, TWBXMeetingAccountInfo * pAccount, JMErrorCodeDef::EJMMeetingAccountErrorCode eErrCode);

typedef void (*pf_jmsdk_IWbxMeetingAccountObserve_OnNoticeActiveAccountChange)(bool bExistActiveAccount);

typedef void (*pf_jmsdk_IWbxMeetingAccountObserve_OnNoticeSessionTicketRefreshed)(const wstring& strSessionTicket);

typedef void (*pf_jmsdk_IWbxMeetingAccountObserve_OnNoticeInvalidCertInMeetingSite)(JMErrorCodeDef::EJMMeetingAccountErrorCode eErrCode);

typedef void (*pf_jmsdk_IWbxMeetingAccountObserve_OnCheckSSOSiteListReady)();

typedef void (*pf_jmsdk_IWbxMeetingAccountObserve_OnCheckSiteSSOFlagReady)(const wstring& strSiteUrl, E_WBX_SITE_SSO_FLAG flag);


/***
*	IMeetingAccountInfoDelegateWrapper
***/
#define JMSDK_IMeetingAccountInfoDelegate_GetWbxAccountsAssocAsync "JMSDK_IMeetingAccountInfoDelegate_GetWbxAccountsAssocAsync"

#define JMSDK_IMeetingAccountInfoDelegate_GetDefWbxAccountAsync "JMSDK_IMeetingAccountInfoDelegate_GetDefWbxAccountAsync"

#define JMSDK_IMeetingAccountInfoDelegate_SetDefWbxAccountAsync "JMSDK_IMeetingAccountInfoDelegate_SetDefWbxAccountAsync"

#define JMSDK_IMeetingAccountInfoDelegate_DelWbxAccountAssocAsync "JMSDK_IMeetingAccountInfoDelegate_DelWbxAccountAssocAsync"

typedef HRESULT (*pf_jmsdk_IMeetingAccountInfoDelegate_GetWbxAccountsAssocAsync)();

typedef HRESULT (*pf_jmsdk_IMeetingAccountInfoDelegate_GetDefWbxAccountAsync)();

typedef HRESULT (*pf_jmsdk_IMeetingAccountInfoDelegate_SetDefWbxAccountAsync)(wstring const& strSite, wstring const& strUser, wstring const& strPwd, BOOL isSSO);

typedef HRESULT (*pf_jmsdk_IMeetingAccountInfoDelegate_DelWbxAccountAssocAsync)(wstring const& strSite);


/***
*	IInstantMeetingEventWrapper
***/
#define JMSDK_IInstantMeetingEvent_OnMeetingStart "JMSDK_IInstantMeetingEvent_OnMeetingStart"

#define JMSDK_IInstantMeetingEvent_OnMeetingError "JMSDK_IInstantMeetingEvent_OnMeetingError"

#define JMSDK_IInstantMeetingEvent_OnMeetingEnd "JMSDK_IInstantMeetingEvent_OnMeetingEnd"

#define JMSDK_IInstantMeetingEvent_OnMeetingInvitation "JMSDK_IInstantMeetingEvent_OnMeetingInvitation"

#define JMSDK_IInstantMeetingEvent_OnMeetingCancelInvitation "JMSDK_IInstantMeetingEvent_OnMeetingCancelInvitation"

#define JMSDK_IInstantMeetingEvent_OnMeetingDecline "JMSDK_IInstantMeetingEvent_OnMeetingDecline"

#define JMSDK_IInstantMeetingEvent_OnPopupWaitDialog "JMSDK_IInstantMeetingEvent_OnPopupWaitDialog"

#define JMSDK_IInstantMeetingEvent_OnCloseWaitDialog "JMSDK_IInstantMeetingEvent_OnCloseWaitDialog"

#define JMSDK_IInstantMeetingEvent_OnShowErrorDialog "JMSDK_IInstantMeetingEvent_OnShowErrorDialog"

#define JMSDK_IInstantMeetingEvent_OnGetShortJoinURL "JMSDK_IInstantMeetingEvent_OnGetShortJoinURL"

#define JMSDK_IInstantMeetingEvent_OnCMRMeetingStarted "JMSDK_IInstantMeetingEvent_OnCMRMeetingStarted"

#define JMSDK_IInstantMeetingEvent_OnCMRMeetingJoined "JMSDK_IInstantMeetingEvent_OnCMRMeetingJoined"

#define JMSDK_IInstantMeetingEvent_OnCMRMeetingFailed "JMSDK_IInstantMeetingEvent_OnCMRMeetingFailed"

#define JMSDK_IInstantMeetingEvent_OnCMRMeetingEnded "JMSDK_IInstantMeetingEvent_OnCMRMeetingEnded"

typedef void (*pf_jmsdk_IInstantMeetingEvent_OnMeetingStart)(wstring const& strMeetingKey, wstring const& strSessionName, BOOL bHost);

typedef void (*pf_jmsdk_IInstantMeetingEvent_OnMeetingError)(wstring const& strMeetingKey, wstring const& strSessionName, BOOL bHost);

typedef void (*pf_jmsdk_IInstantMeetingEvent_OnMeetingEnd)(wstring const& strMeetingKey, wstring const& strSessionName, BOOL vbHost);

typedef void (*pf_jmsdk_IInstantMeetingEvent_OnMeetingInvitation)(wstring const& strSessionName);

typedef void (*pf_jmsdk_IInstantMeetingEvent_OnMeetingCancelInvitation)(wstring const& strSessionName);

typedef void (*pf_jmsdk_IInstantMeetingEvent_OnMeetingDecline)(wstring const& strSessionName, wstring const& strBuddyName);

typedef void (*pf_jmsdk_IInstantMeetingEvent_OnPopupWaitDialog)();

typedef void (*pf_jmsdk_IInstantMeetingEvent_OnCloseWaitDialog)();

typedef void (*pf_jmsdk_IInstantMeetingEvent_OnShowErrorDialog)(int nErrorCode);

typedef void (*pf_jmsdk_IInstantMeetingEvent_OnGetShortJoinURL)(wstring const& pszSiteURL, wstring const& strEventID, wstring const& pszMeetingKey, wstring const& pszShortJoinURL, int eSenario);

typedef void (*pf_jmsdk_IInstantMeetingEvent_OnCMRMeetingStarted)(const CMR_MeetingData & info);

typedef void (*pf_jmsdk_IInstantMeetingEvent_OnCMRMeetingJoined)(const CMR_MeetingData & info);

typedef void (*pf_jmsdk_IInstantMeetingEvent_OnCMRMeetingFailed)(int nErrorCode);

typedef void (*pf_jmsdk_IInstantMeetingEvent_OnCMRMeetingEnded)();


/***
*	IDSMgrEventWrapper
***/
#define JMSDK_IDSMgrEvent_OnStartingDialogShow "JMSDK_IDSMgrEvent_OnStartingDialogShow"

#define JMSDK_IDSMgrEvent_OnNotifyUIUpdate "JMSDK_IDSMgrEvent_OnNotifyUIUpdate"

#define JMSDK_IDSMgrEvent_OnSessionStarted "JMSDK_IDSMgrEvent_OnSessionStarted"

#define JMSDK_IDSMgrEvent_OnSessionEnded "JMSDK_IDSMgrEvent_OnSessionEnded"

#define JMSDK_IDSMgrEvent_OnSessionFailed "JMSDK_IDSMgrEvent_OnSessionFailed"

#define JMSDK_IDSMgrEvent_OnSessionStopped "JMSDK_IDSMgrEvent_OnSessionStopped"

#define JMSDK_IDSMgrEvent_OnRecvSessionInvitation "JMSDK_IDSMgrEvent_OnRecvSessionInvitation"

#define JMSDK_IDSMgrEvent_OnDeclineInvitation "JMSDK_IDSMgrEvent_OnDeclineInvitation"

#define JMSDK_IDSMgrEvent_OnRequestOpenChat "JMSDK_IDSMgrEvent_OnRequestOpenChat"

#define JMSDK_IDSMgrEvent_OnRequestMinimizeChat "JMSDK_IDSMgrEvent_OnRequestMinimizeChat"

#define JMSDK_IDSMgrEvent_OnUserJoined "JMSDK_IDSMgrEvent_OnUserJoined"

#define JMSDK_IDSMgrEvent_OnUserTryLeave "JMSDK_IDSMgrEvent_OnUserTryLeave"

#define JMSDK_IDSMgrEvent_OnUserLeft "JMSDK_IDSMgrEvent_OnUserLeft"

#define JMSDK_IDSMgrEvent_OnCleanSession "JMSDK_IDSMgrEvent_OnCleanSession"

#define JMSDK_IDSMgrEvent_OnCleanUp "JMSDK_IDSMgrEvent_OnCleanUp"

#define JMSDK_IDSMgrEvent_OnErrorMsg "JMSDK_IDSMgrEvent_OnErrorMsg"

#define JMSDK_IDSMgrEvent_OnPresenterDidChange "JMSDK_IDSMgrEvent_OnPresenterDidChange"

typedef void (*pf_jmsdk_IDSMgrEvent_OnStartingDialogShow)(bool bShow);

typedef void (*pf_jmsdk_IDSMgrEvent_OnNotifyUIUpdate)();

typedef void (*pf_jmsdk_IDSMgrEvent_OnSessionStarted)(const wstring& strSessionName);

typedef void (*pf_jmsdk_IDSMgrEvent_OnSessionEnded)();

typedef void (*pf_jmsdk_IDSMgrEvent_OnSessionFailed)(INT eType);

typedef void (*pf_jmsdk_IDSMgrEvent_OnSessionStopped)();

typedef void (*pf_jmsdk_IDSMgrEvent_OnRecvSessionInvitation)(const wstring& strSessionName);

typedef void (*pf_jmsdk_IDSMgrEvent_OnDeclineInvitation)(const wstring& strSessionName);

typedef void (*pf_jmsdk_IDSMgrEvent_OnRequestOpenChat)();

typedef void (*pf_jmsdk_IDSMgrEvent_OnRequestMinimizeChat)();

typedef void (*pf_jmsdk_IDSMgrEvent_OnUserJoined)();

typedef void (*pf_jmsdk_IDSMgrEvent_OnUserTryLeave)(BOOL bHost);

typedef void (*pf_jmsdk_IDSMgrEvent_OnUserLeft)();

typedef void (*pf_jmsdk_IDSMgrEvent_OnCleanSession)(const wstring strSessionName);

typedef void (*pf_jmsdk_IDSMgrEvent_OnCleanUp)();

typedef void (*pf_jmsdk_IDSMgrEvent_OnErrorMsg)(const wstring& strSessionName, INT eType);

typedef void (*pf_jmsdk_IDSMgrEvent_OnPresenterDidChange)();


/***
*	JMProxyWrapper
***/
#define JMSDK_JMProxy_getProxy "JMSDK_JMProxy_getProxy"

typedef bool (*pf_jmsdk_JMProxy_getProxy)(const char *url, string &strServer, unsigned short &port, unsigned int &proxyType, unsigned int &proxyAuth, string &strUsername, string &strPassword, string &strBypass);


/***
*	INetworkTransportWrapper
***/
#define JMSDK_INetworkTransport_HttpRequest "JMSDK_INetworkTransport_HttpRequest"

#define JMSDK_INetworkTransport_HttpRequestAsync "JMSDK_INetworkTransport_HttpRequestAsync"

#define JMSDK_INetworkTransport_Registered "JMSDK_INetworkTransport_Registered"

typedef void (*pf_jmsdk_INetworkTransport_HttpRequest)(const std::string& httpUrl, const std::vector<std::string>& httpHeader, const std::string& httpPostData, JMHttpMethod httpMethod, NetUtilSuccessProcT successProc, NetUtilErrorProcT errorProc);

typedef void (*pf_jmsdk_INetworkTransport_HttpRequestAsync)(const std::string& httpUrl, const std::vector<std::string>& httpHeader, const std::string& httpPostData, JMHttpMethod httpMethod, NetUtilSuccessProcT successProc, NetUtilErrorProcT errorProc);

typedef bool (*pf_jmsdk_INetworkTransport_Registered)();

